############### ###############
## F_H2_covid
## Project: CBO
## Author: Kamil Kouhen
## Date of creation: 23/06/2022
############### ###############

#Uniform Path
path <- here("Output/For Publication/Figures/F_")

pct_format = scales::percent_format(accuracy = .1)

  ##Scatter plot
  plot1 <- ggplot(CBO_groups_final,
                  aes(x = covid_policy)) + 
    geom_bar() +
    labs(
      x = "CBO has adopted COVID-19 policy", 
      y = "Number of CBOs"
    ) + 
    scale_x_discrete(labels = c('No','Yes')) +
    theme_minimal() +
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 3, 
      vjust = -0.5) + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times")) +
    scale_y_continuous(limits = c(0,700)) + 
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  plot2 <- ggplot(CBO_groups_final,
                  aes(x = covid_adaptation)) + 
    geom_bar() +
    labs(
      x = "CBO has seized COVID-related opportunities", 
      y = "Number of CBOs"
    ) +
    scale_x_discrete(labels = c('Has not led to any new activities',
                                'Has prompted some new activities', 
                                'Caused you to start a lot of new activities', 
                                "Completely redefined your organization's activities"),
                     guide = guide_axis(angle = 45)) +
    theme_minimal() +
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 3, 
      vjust = -0.5) + 
    theme(text = element_text(size=11, family="Times")) +
    scale_y_continuous(limits = c(0,700))
  
  ggarrange(plot1, plot2, align = "hv") +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 4, filename = paste0(path, "H2_", "covid.png"), device = png,  dpi=200)



